	function [Gsb, Zsb, Psb] = PZ_2_BS_Z(G, Z, P, wc1T, wc2T, OmegaT);
 
	% 	Transforms the poles and zeros of a digital lowpass filter with   
	% 	cutoff frequency, OmegaT, to a stopband filter with the passband  
	%	edges wc1T and wc2T.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2009-11-15
	% Modified by: 	 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	alfa = cos((wc2T + wc1T)/2)/cos((wc2T- wc1T)/2);
	k = tan((wc2T - wc1T)/2)*tan(OmegaT/2);
	beta = 2*alfa/(k+1);
	gama = (1-k)/(k+1);
	
	for n = 1:length(Z)
		a = beta*(Z(n)-1);
		b = gama*Z(n)-1;
		c = sqrt(-4*(Z(n)-gama)*b + (beta*(1-Z(n)))^2);
		Zsb(n) = (c + a)/b/2;
		Zsb(n+length(Z)) = (-c + a)/b/2;
	end

	for n = 1:length(P)
		a = beta*(P(n)-1);
		b = gama*P(n)-1;
		c = sqrt(-4*(P(n)-gama)*b + (beta*(1-P(n)))^2);
		Psb(n) = (c + a)/b/2;
		Psb(n+length(P)) = (-c + a)/b/2;
	end
	Zsb = sort(Zsb);
	Psb = sort(Psb);
	H0 = real(PZ_2_FREQ_Z(G, Z, P, 0));
	Gsb =  real(H0*prod(1-Psb)/prod(1-Zsb));
